// To parse this JSON data, do
//
//     final nomineeResponseModel = nomineeResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/savings/savings_response_model.dart';

NomineeCreateResponseModel nomineeResponseModelFromJson(String str) => NomineeCreateResponseModel.fromJson(json.decode(str));

String nomineeResponseModelToJson(NomineeCreateResponseModel data) => json.encode(data.toJson());

class NomineeCreateResponseModel {
  final String? remark;
  final String? status;
  final Message? message;
  final Nominee? data;

  NomineeCreateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory NomineeCreateResponseModel.fromJson(Map<String, dynamic> json) => NomineeCreateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Nominee.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}
